function snipped = linebreaksnip( vec )
% snipped = nansnip( vec )
% 
% Nansnip snips long vectors with numbers and nans into smaller vectors.
% The vector is snipped everywhere it contains a nan. A cell array
% with all the sub vectors in the vec field is returned. The nans
% themselves are removed. Use snippes{ index } to access the different
% vectors.
% 
% For example [ 1 2 3 4 nan 5 6 nan 7 8 9 10] is snipped into:
% [1 2 3 4]
% [5 6]
% [7 8 9 10]
% 
% Yannick Kremer 2010

if size(vec, 2)>1,
    vec = vec';
end

snips = find( ( vec == 10 ));

if snips(1) ~= 1,
    snips = [ 0; snips ];
end


if ~ isnan( snips(end)),
    snips = [ snips; length(vec)+1];
end


snipped = cell( length(snips)-2, 1);

for idx = 1: length( snips )-2,  
    snipped{idx} = forcerow( vec( (snips(idx)+1) : (snips(idx+1)-1))) ;
end


    